/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.config.NBTProcessorConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.utils.AnnotationHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class NBTManager {
    private static final List<INBTProcessor> processors = new ArrayList<INBTProcessor>();

    public static void loadProcessors() {
        if (processors.isEmpty()) {
            processors.addAll(AnnotationHelper.getNBTProcessors());
            NBTProcessorConfig.setup(processors);
        }
    }

    @NotNull
    public static ItemInfo getPersistentInfo(@NotNull ItemInfo info) {
        if (!info.hasNBT() || info.is(PETags.Items.NBT_WHITELIST) || EMCMappingHandler.hasEmcValue(info)) {
            return info;
        }
        ArrayList<CompoundTag> persistentNBT = new ArrayList<CompoundTag>();
        for (INBTProcessor processor : processors) {
            CompoundTag nbt;
            if (!NBTProcessorConfig.isEnabled(processor) || !processor.hasPersistentNBT() || !NBTProcessorConfig.hasPersistent(processor) || (nbt = processor.getPersistentNBT(info)) == null) continue;
            persistentNBT.add(nbt);
        }
        return ItemInfo.fromItem((ItemLike)info.getItem(), ItemHelper.recombineNBT(persistentNBT));
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcValue(@NotNull ItemInfo info) {
        long emcValue = EMCMappingHandler.getStoredEmcValue(info);
        if (!info.hasNBT()) {
            return emcValue;
        }
        if (emcValue == 0L && (emcValue = EMCMappingHandler.getStoredEmcValue(ItemInfo.fromItem((ItemLike)info.getItem()))) == 0L) {
            return 0L;
        }
        for (INBTProcessor processor : processors) {
            if (!NBTProcessorConfig.isEnabled(processor)) continue;
            try {
                emcValue = processor.recalculateEMC(info, emcValue);
            }
            catch (ArithmeticException e) {
                return emcValue;
            }
            if (emcValue > 0L) continue;
            return 0L;
        }
        return emcValue;
    }
}

